/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSUDDIPublishingRegistry;
import filenet.ws.api.uddi.WSUDDIRegistry;
import filenet.ws.utils.WSWorkflowWSDLGenerator;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.juddi.datatype.business.BusinessEntity;

public class WSPublishToUDDI {
    protected static Logger logger = Logger.getLogger("filenet.ws.utils");
    protected static final String m_className = "WSPublishToUDDI";
    private VWWorkflowSignature m_workflowSignature = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    private BusinessEntity[] m_businessEntities = null;
    private VWSession m_session = null;
    private String m_workClassName = null;
    private boolean m_bVersionAgnostic = false;
    private Hashtable m_portTypes = new Hashtable();
    private String m_serviceName = null;
    private String m_serviceDescription = null;
    private String m_timestamp = null;
    private DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance();

    public WSPublishToUDDI(VWSession session) throws Exception {
        String method = "WSPublishToUDDI(VWSession, VWWorkflowSignature)";
        if (session == null) {
            VWException ex = new VWException("filenet.ws.utils.workflowToUDDINullVWSession", "Null VWSession");
            logger.throwing(m_className, method, ex);
        }
        this.m_session = session;
    }

    public WSPublishToUDDI(VWSession session, VWWorkflowSignature signature) throws Exception {
        String method = "WSPublishToUDDI(VWSession, VWWorkflowSignature)";
        if (session == null) {
            VWException ex = new VWException("filenet.ws.utils.workflowToUDDINullVWSession", "Null VWSession");
            logger.throwing(m_className, method, ex);
        }
        this.m_session = session;
        this.setWorkflow(signature);
    }

    private void setWorkflow(VWWorkflowSignature signature) throws Exception {
        this.m_workflowSignature = signature;
        this.m_workClassName = this.m_workflowSignature.getName();
        this.m_bVersionAgnostic = this.m_workflowSignature.getVersionAgnostic();
        this.m_workflowDefinition = this.m_session.fetchWorkflowDefinition(this.m_workflowSignature.getWorkspaceId(), this.m_workClassName, false);
        this.m_serviceName = this.m_workClassName + "Service";
        Date transferDateTime = this.m_workflowSignature.getTransferDateTime();
        if (transferDateTime != null) {
            this.m_timestamp = this.m_dateTimeFormatter.format(transferDateTime);
        }
        this.m_serviceDescription = this.m_serviceName + "\n" + this.m_timestamp;
        this.getPortTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessEntity publishBusiness(VWUDDIRegistry vwUDDIRegistry, WSUDDIRegistry wsUDDIRegistry, WSBusinessEntity wsBusinessEntity) throws Exception {
        String method = "publishBusiness";
        try {
            logger.entering(m_className, method);
            String businessEntityKey = vwUDDIRegistry.getBusinessKey();
            WSUDDIPublishingRegistry wsUddiPublishingRegistry = null;
            BusinessEntity uddiBusinessEntity = null;
            if (vwUDDIRegistry.getPublish()) {
                wsUddiPublishingRegistry = new WSUDDIPublishingRegistry(wsUDDIRegistry);
            }
            if (wsBusinessEntity != null) {
                uddiBusinessEntity = wsBusinessEntity.getBusinessEntity();
            }
            if (uddiBusinessEntity != null && businessEntityKey != null && VWStringUtils.compare(uddiBusinessEntity.getBusinessKey(), businessEntityKey) != 0) {
                uddiBusinessEntity = null;
            }
            if (uddiBusinessEntity == null) {
                uddiBusinessEntity = WSUDDIPublishingRegistry.newBussinessEntity(vwUDDIRegistry.getBusinessName(), vwUDDIRegistry.getBusinessDescription());
            }
            if (uddiBusinessEntity != null && wsUddiPublishingRegistry != null) {
                if (wsBusinessEntity.hasBusinessKey()) {
                    wsBusinessEntity.refreshBusinessServices();
                    uddiBusinessEntity.setBusinessServices(wsBusinessEntity.getBusinessEntity().getBusinessServices());
                }
                uddiBusinessEntity = wsUddiPublishingRegistry.publishBusinessEntity(uddiBusinessEntity);
                if (wsBusinessEntity.hasBusinessKey()) {
                    wsBusinessEntity.refreshBusinessServices();
                    uddiBusinessEntity = wsBusinessEntity.getBusinessEntity();
                }
            }
            BusinessEntity businessEntity = uddiBusinessEntity;
            Object var10_9 = null;
            logger.exiting(m_className, method);
            return businessEntity;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            logger.exiting(m_className, method);
            throw throwable;
        }
    }

    public void publishService(VWUDDIRegistry vwUDDIRegistry, WSUDDIRegistry wsUDDIRegistry, WSBusinessEntity wsBusinessEntity, VWWorkflowSignature signature) throws Exception {
        String method = "publishService";
        String businessEntityKey = wsBusinessEntity.getBusinessKey();
        if (businessEntityKey == null || businessEntityKey.length() <= 0) {
            return;
        }
        if (!vwUDDIRegistry.getPublish()) {
            return;
        }
        this.setWorkflow(signature);
        WSUDDIPublishingRegistry wsUddiPublishingRegistry = new WSUDDIPublishingRegistry(wsUDDIRegistry);
        if (this.m_portTypes != null && this.m_portTypes.size() > 0) {
            if (businessEntityKey != null) {
                Object obj = null;
                String[] portTypeNames = null;
                String[] bindingDescriptions = null;
                String[] accessPoints = null;
                String[] tModelKeys = null;
                String wsdlURL = null;
                String tModelDescription = null;
                String soapAddress = this.getSoapAddress();
                wsUddiPublishingRegistry.deleteServiceRelatedTModels(wsBusinessEntity, this.m_serviceName);
                wsdlURL = soapAddress;
                tModelDescription = "WSDL tModel for " + this.m_workClassName;
                if (this.m_timestamp != null) {
                    tModelDescription = tModelDescription + "\n" + this.m_timestamp;
                }
                tModelDescription = tModelDescription + "\nPublished: " + DateFormat.getDateTimeInstance().format(new Date());
                String tModelKey = wsUddiPublishingRegistry.publishTModel(this.m_workClassName, tModelDescription, wsdlURL);
                portTypeNames = new String[this.m_portTypes.size()];
                bindingDescriptions = new String[portTypeNames.length];
                accessPoints = new String[portTypeNames.length];
                tModelKeys = new String[portTypeNames.length];
                Collection portTypes = this.m_portTypes.values();
                Iterator it = portTypes.iterator();
                int i = 0;
                while (it.hasNext()) {
                    obj = it.next();
                    if (obj == null || !(obj instanceof PortType)) continue;
                    PortType portType = obj;
                    portTypeNames[i] = portType.getPortTypeName();
                    bindingDescriptions[i] = portType.getBindingName();
                    accessPoints[i] = soapAddress;
                    tModelKeys[i] = tModelKey;
                    ++i;
                }
                wsUddiPublishingRegistry.publishBusinessService(wsBusinessEntity, this.m_serviceName, this.m_serviceDescription, portTypeNames, bindingDescriptions, accessPoints, tModelKeys);
            }
        } else {
            VWException ex = new VWException("filenet.ws.utils.missingPortType", "Missing port types");
            logger.throwing(m_className, method, ex);
        }
    }

    public BusinessEntity[] getPublishedBusinessEntites() {
        return this.m_businessEntities;
    }

    private void getPortTypes() throws VWException {
        VWPartnerLinkDefinition[] partnerLinks = this.m_workflowDefinition.getPartnerLinks();
        if (partnerLinks != null && partnerLinks.length > 0) {
            for (int i = 0; i < partnerLinks.length; ++i) {
                if (partnerLinks[i] == null || partnerLinks[i].getMyPortType() == null) continue;
                this.m_portTypes.put(partnerLinks[i].getName(), new PortType(partnerLinks[i].getMyPortType()));
            }
            this.getReceiveReplyInstructions();
            String obj = null;
            for (int i = 0; i < partnerLinks.length; ++i) {
                if (partnerLinks[i] == null || partnerLinks[i].getMyPortType() == null || ((PortType)this.m_portTypes.get(obj = partnerLinks[i].getName())).isUsed()) continue;
                this.m_portTypes.remove(obj);
            }
        }
    }

    private void getReceiveReplyInstructions() throws VWException {
        VWMapDefinition[] maps = this.m_workflowDefinition.getMaps();
        if (maps != null && maps.length > 0) {
            VWMapDefinition map = null;
            VWMapNode[] mapNodes = null;
            VWCompoundStepDefinition step = null;
            VWInstructionDefinition[] instructions = null;
            for (int i = 0; i < maps.length; ++i) {
                map = maps[i];
                if (map == null || (mapNodes = map.getSteps()) == null || mapNodes.length <= 0) continue;
                Object obj = null;
                String partnerLinkName = null;
                for (int j = 0; j < mapNodes.length; ++j) {
                    if (mapNodes[j] == null || !(mapNodes[j] instanceof VWCompoundStepDefinition) || (instructions = (step = (VWCompoundStepDefinition)mapNodes[j]).getInstructions()) == null || instructions.length <= 0) continue;
                    for (int k = 0; k < instructions.length; ++k) {
                        partnerLinkName = null;
                        if (instructions[k] != null) {
                            if (instructions[k] instanceof VWReceiveInstruction) {
                                partnerLinkName = ((VWReceiveInstruction)instructions[k]).getPartnerLinkName();
                            } else if (instructions[k] instanceof VWReplyInstruction) {
                                partnerLinkName = ((VWReplyInstruction)instructions[k]).getPartnerLinkName();
                            }
                        }
                        if (partnerLinkName == null || this.m_portTypes == null || (obj = this.m_portTypes.get(partnerLinkName)) == null || !(obj instanceof PortType)) continue;
                        ((PortType)obj).setUsed(true);
                    }
                }
            }
        }
    }

    private String getSoapAddress() throws Exception {
        return WSWorkflowWSDLGenerator.getWSDLURL(this.m_session.getConnectionPointName(), this.m_workClassName, this.m_workflowSignature.getWorkspaceId(), this.m_bVersionAgnostic);
    }

    class PortType {
        boolean m_bUsed = false;
        String m_name;

        PortType(String name) {
            this.m_name = name;
        }

        String getBindingName() {
            return this.m_name + "SoapBinding";
        }

        String getPortTypeName() {
            return this.m_name + "PortType";
        }

        void setUsed(boolean bUsed) {
            this.m_bUsed = bUsed;
        }

        boolean isUsed() {
            return this.m_bUsed;
        }
    }
}

